<?php

	// Définition de la classe
	class Voiture {
		/* Attributs */
		private $nom;
		private $marque;
		private $longueur;
		private $largeur;
		private $hauteur;

		/* Constructeur */
		public function __construct(string $nom, string $marque) {
			$this->nom = $nom;
			$this->marque = $marque;
			$this->longueur = 0;
			$this->largeur = 0;
			$this->hauteur = 0;
		}
		
		/* Getters */
		public function getNom() : string {
			return $this->nom;
		}
		
		public function getMarque() : string {
			return $this->marque;
		}
		
		public function getLongueur() : float  {
			return $this->longueur;
		}
		
		public function getLargeur() : float  {
			return $this->largeur;
		}
		
		public function getHauteur() : float  {
			return $this->hauteur;
		}
		
		/* Getters */
		
		public function setNom(string $nom) : void {
			$this->nom = $nom;
		}
		
		public function setMarque(string $marque) : void {
			$this->marque = $marque;
		}
		
		public function setLongueur(float $longueur) : void {
			$this->longueur = $longueur;
		}
		
		public function setLargeur(float $largeur) : void {
			$this->largeur = $largeur;
		}
		
		public function setHauteur(float $hauteur) : void {
			$this->hauteur = $hauteur;
		}
		
		/* Autres méthodes */
		public function afficher() : void {
			echo $this->nom." (".$this->marque.")";
		}
		
		/* Méthodes magiques */
		public function __toString() : string {
			return $this->nom." (".$this->marque.")<br/>Dimensions : ".$this->longueur." x ".$this->largeur." x ".$this->hauteur." (L x l x h)";
		}
	}