<!doctype html>
<html lang=en>
<head>
    <meta charset=utf-8>
    <title>Session PHP</title>
</head>
<body>

<?php
        //Démaragge de la session
        @session_start();

		/***************************************** Fonctions *****************************************/

		function creationSession($nom) {

				$_SESSION["nom"]=$nom;

				print "<p>Session créée : ".$_SESSION["nom"]."</p>";
				print "<a href='/Exercice3.php'>retour</a>";
		}

		function suppressionSession() {
				if(isset($_SESSION["nom"]))
					unset($_SESSION["nom"]);

				//Et suppression de la photo
				if(isset($_SESSION["photo"]))
				{
					if (file_exists($_SESSION["photo"])) {
						unlink($_SESSION["photo"]);
					}
					unset($_SESSION["photo"]);
				}

				print "<p>Session supprimée !</p>";
				print "<a href='/Exercice3.php'>retour</a>";
		}

		function actionSession($action, $nom) {

				if($action == "createSession" && isset($nom)) {
								//Si création de la session
								creationSession($nom);
				} else if($action == "removeSession") {
								//Si Suppression de la session
								suppressionSession();
				}
		}

		function ajoutPhoto($photo) {
				if(move_uploaded_file($photo["tmp_name"], $photo["name"])) {
								$_SESSION["photo"] = $photo["name"];

								print "<p>Photo ajouté ! </p>";
								print "<img src='".$_SESSION["photo"]."'/>";
								print "<a href='/Exercice3.php'>retour</a>";
				} else {
								print "<p>Problème avec la photo!</p>";
				}
		}

		function supprPhoto() {
				if (file_exists($_SESSION["photo"])) {
								unlink($_SESSION["photo"]);
				}
				unset($_SESSION["photo"]);

				print "<p>Photo supprimé ! </p>";
				print "<a href='/Exercice3.php'>retour</a>";
		}

		function actionPhoto($action, $photo) {
				if($_POST["actionPhoto"] == "addPhoto" && isset($photo)) {
								//Si action ajout d'une photo
								ajoutPhoto($photo);
				} else if ($_POST["actionPhoto"] == "removePhoto") {
								//Si action suppression d'une photo
								supprPhoto();
				}
		}

		function afficheUtilisateur() {
				print "<p>Votre nom est : ".$_SESSION["nom"]."</p>";
		}

		function affichePhoto() {
				print "<img src='".$_SESSION["photo"]."'/>";
		}

		function formAjoutPhoto() {
				print "<form method='post' action='/Exercice3.php' enctype='multipart/form-data'>";

								print "<input type='hidden' name='actionPhoto' value='addPhoto'/>";
								print "<input type='file' name='photo'/>";
								print "<input type='submit' value='Ajouter photo'/>";

				print "</form>";
		}

		function formSupprPhoto() {
				print "<form method='post' action='/Exercice3.php' enctype='multipart/form-data'>";

								print "<input type='hidden' name='actionPhoto' value='removePhoto'/>";
								print "<input type='submit' value='Supprimer photo'/>";

				print "</form>";
		}

		function formSupprSession() {
				print "<form method='post' action='/Exercice3.php'>";

								print "<input type='hidden' name='actionSession' value='removeSession'/>";
								print "<input type='submit' value='Déconnecter'/>";

				print "</form>";
		}

		function formCreaSession() {
				print "<form method='post' action='/Exercice3.php'>";

								print "<label>Nom : </label><input type='text' name='nom'>";
								print "<input type='hidden' name='actionSession' value='createSession'/>";
								print "<input type='submit' value='Valider'/>";

				print "</form>";
		}


		/***************************************** Fin fonctions *****************************************/

		/********************************************* Main *********************************************/

        if(isset($_POST["actionSession"])) {
                //Si on lance une action sur la session utilisateur
				$nom = "";
				if(isset($_POST["nom"]))
					$nom = $_POST["nom"];
				
                actionSession($_POST["actionSession"], $nom);

        } else if(isset($_SESSION["nom"])) {
                //Si la session utilisateur existe
                afficheUtilisateur();

                if(isset($_POST["actionPhoto"])) {
                     //Si on lance une action sur la photo
                        actionPhoto($_POST["actionPhoto"], $_FILES["photo"]);

                } else if(isset($_SESSION["photo"])) {
                        //si une photo est en session
                        affichePhoto();

                        formSupprPhoto();

                } else {
                        //Si pas de photo en session
                        formAjoutPhoto();
                }

                formSupprSession();
        } else {
                //Si pas de session
                formCreaSession();
        }

                /********************************************* Fin main *********************************************/
?>

</body>
</html>