<?php
	/*Exercice 5 (FPDF v1.83) */
	require('fpdf/fpdf.php');
	
	function generationRectangles($img)
	{
		// Gnration des 5 rectangles
		for($i=0 ; $i<5 ; $i++)
		{
			$couleurFond = imagecolorallocate($img, rand(0,200), rand(0,200), rand(0,200));
			imagefilledrectangle($img, rand(50,250), rand(50,250), rand(50,250), rand(50,250), $couleurFond);
		}
	}

	// Partie "GD"
	$img = imagecreatetruecolor(300,300);
	$couleurFondImage =  imagecolorallocate($img, 240, 240, 240); 
	// Application de la couleur sur l'image
	imagefill($img, 0, 0, $couleurFondImage);
	
	generationRectangles($img);
  
	// Enregistrement de l'image JPG
	imagejpeg($img,'img_95.jpg', 95);
	
	// Rotation de l'image
	$couleurRotation =  imagecolorallocate($img, 100, 240, 150); 
	$img = imagerotate($img, 45, $couleurRotation);
	
	// Enregistrement de l'image PNG
	imagepng($img,'img_rotation.png');
	// Efface la ressource
	imagedestroy($img);
  
	// Cration du PDF
	$doc = new FPDF();
	
	$doc->AddPage();
	
	$doc->SetFont('Arial','B',12);
	$doc->Text(20,20,'Image JPEG (Qualit 95)');
	$doc->Image('img_95.jpg',20,25,100,100,'JPEG');
	
	$doc->Text(20,150,'Image PNG (Rotation de 45)');
	$doc->Image('img_rotation.png',20,155,100,100,'PNG');
	
	$doc->Output('exercice_5.pdf','F');
?>